package com.ht.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.ht.bo.KanglaEbookBO;
import com.ht.vo.Product;

public class ConnectionUtil {
	
	//static final Cluster cluster = CouchbaseCluster.create("169.254.245.122");
	
	static final Cluster cluster = CouchbaseCluster.create(DefaultCouchbaseEnvironment.builder().
            bootstrapCarrierEnabled(false).build(), Arrays.asList("127.0.0.1"));
	
	static public Bucket getTheBucket() throws Exception {
		
		Bucket bucket = cluster.openBucket("Kanglabook","",3, TimeUnit.MINUTES);
		return bucket;
		
	}

	static void closeTheBucketConnection() throws Exception {
		cluster.disconnect();		
	}
	
	
	 
  static public List<Product> populateProduct(){
	  ArrayList<Product> bookList = new ArrayList<Product>();
	  Product book = new Product("LCB2015", "Learning Couchbase",
			     "The book to write NOSQL development in Couchbase", Float.valueOf(9454.45f), "cb.img");
	  bookList.add(book);
	  return bookList;
	  
  }
  
  static public String getProductID(Bucket theBucket){
	  String productID ="product::book::"+theBucket.counter("product::book",1).content();
	  return productID;
  }

  static public String getCatalogID(){
	  String catID ="catalog::book";
	  return catID;
  }
  
  static public String constructCategoryID(String category){
	  String catID ="product::"+ category.trim() +"::productList";
	  return catID;
  }
  

	static public  ArrayList<Product> populateOrderList(String subCategory) {
		
		KanglaEbookBO bo = new KanglaEbookBO();
		String category = ConnectionUtil.constructCategoryID(subCategory);
		List<Product> prodList = bo.findAllBooksBySubCatalog(category);
		return  (ArrayList<Product>) prodList;
	}
}
